# -*- coding: utf-8 -*-
import numpy as np
import csv


def ud2ud( file_name, usecols, skiprows, delimiter ):
    '''使用者自定型
    mean, var: n by 1 numpy array
    
    '''
    limi_idx = usecols[0] # idx of limi
    f=open(file_name,"rb")
    c=csv.reader(f,delimiter = delimiter )

    #skip rows
    for skiprow in xrange(skiprows):
        c.next()
    try:
        nol = []
            
        for line in c :
            d=line
            
            a=int(d[limi_idx])+1
            nol.append(a)
                
    except StopIteration:
        pass
    
    nolmax=max(nol)

    f2=open(file_name,"rb")
    readcsv=csv.reader( f2,delimiter= delimiter )
    #skip rows
    for skiprow in xrange(skiprows):
        readcsv.next()
    try:
        limi = []
        probdens = []
        for i in readcsv:
            d2=i
            a2=int(d2[limi_idx])
            px1=tuple(d2[limi_idx +1 : limi_idx +1 + a2+1])
            px1=px1+tuple([0]*(nolmax-a2 ))
            px=map(float,px1)
            limi.append(px)

            py1=tuple(d2[limi_idx +1 + a2+1 : limi_idx +1 + a2+1+ a2+1])
            py1=py1+tuple([0]*(nolmax-a2 ))
            py=map(float,py1)
            probdens.append(py)
                

    except StopIteration:
        pass
        
        
        
    nl=np.array(nol,ndmin=2).T
    limi=np.array(limi,ndmin=2)
    probdens=np.array(probdens,ndmin=2)
    return nl,limi,probdens

def gs2ud(mean,var):
    '''轉換高斯型資料至使用者自定型
    mean, var: n by 1 numpy array
    
    '''
    limi_norm = np.array([-3.719,-3.090,-2.326,
                          -1.645,-0.524,-0.253,
                           0.000,
                           0.253, 0.524, 1.645,
                           2.326, 3.090, 3.719,])
    limi_n = len(limi_norm)

    nl = np.ones((mean.shape[0],1), dtype=int) * limi_n
    limi = np.kron(np.sqrt(var),limi_norm).reshape((-1,limi_n))+mean
    probdens = limi-mean
    probdens = -(probdens**2)/2/var
    probdens = 1/np.sqrt(2*np.pi*var)*np.exp(probdens)
    return nl,limi,probdens

def uf2ud(low,up):
    limi_norm = np.linspace(-1,1,5)
    limi_n = len(limi_norm)
    nl = np.ones((low.shape[0],1), dtype=int) * limi_n
    limi = np.kron((up-low)/2.,limi_norm)+(up+low)/2.
    probdens = np.ones((low.shape[0],limi_n))*(1./(up-low))

    return nl,limi,probdens

def ud2zs(softpdftype, nl, limi, probdens):
    '''
    user defined to old zs data
    old zs data: a sequence include softpdftype, nl, limi, probdens
        e.g. old zs data = [softpdftype, nl, limi, probdens]
        note: each softpdftype, nl, limi, probdens is a numpy array of data
    '''
    zsdata=[]
    data_count = nl.shape[0]
    zsdata.append([softpdftype]*data_count)
    zsdata.append(nl)
    zsdata.append(limi)
    zsdata.append(probdens)
    return zsdata

def ud2zs_temp(softpdftype, nl, limi, probdens):
    '''
    user defined to new zs data
    new zs data: a sequence of zsdata,
        zsdata is a sequence of pdftype, *pdf_args
        e.g. zsdata1 = (2, nl, limi, probdens)
        e.g. zsdata2 = (10, mean, var)
        e.g. new zs data = (zsdata1, zsdata2)
    '''
    zsdata = []
    if nl.size != 0:
        for n_i, l_i, p_i in zip(nl, limi, probdens):
            zsdata.append([softpdftype, n_i, l_i, p_i])
    return zsdata

def uf2zs(softpdftype, low, up):
    '''
    new zs data
    '''
    limi_norm = np.linspace(-1,1,5)
    limi_n = len(limi_norm)
    nl = np.ones((low.shape[0],1), dtype=int) * limi_n
    limi = np.kron((up-low)/2.,limi_norm)+(up+low)/2.
    probdens = np.ones((low.shape[0],limi_n))*(1./(up-low))
    zsdata = []
    for n_i, l_i, p_i in zip(nl, limi, probdens):
        zsdata.append([softpdftype, n_i, l_i, p_i])
    return zsdata

def zsnew2old(zs):
    '''
    input_zs: a sequence of zsdata,
        zsdata is a sequence of pdftype, pdf_args
        e.g. zsdata1 = (2, nl, limi, probdens)
        e.g. zsdata2 = (10, mean, var)
        e.g. input_zs = (zsdata1, zsdata2)

    output_zs: a sequence include softpdftype, nl, limi, probdens
        e.g. output_zs = [softpdftype, nl, limi, probdens]
        note: each softpdftype, nl, limi, probdens is a numpy array of data
    '''
    data_count = len(zs)
    softpdftype = zs[0][0]
    zsdata=[[softpdftype]*data_count]
    nl=[]
    limi=[]
    probdens=[]
    for s,n,l,p in zs:
        nl.append(n)
        limi.append(l)
        probdens.append(p)
    nl = np.array(nl)
    limi = np.array(limi)
    probdens = np.array(probdens)
    zsdata.append(nl)
    zsdata.append(limi)
    zsdata.append(probdens)
    return zsdata

def zs2ud(zs):
    '''new zs data'''
    softpdftype = 2
    mean = np.array([zsi[1] for zsi in zs]).reshape((-1,1))
    var = np.array([zsi[2] for zsi in zs]).reshape((-1,1))
    nl, limi, probdens = gs2ud(mean, var)
    return softpdftype, nl, limi, probdens

def proba2stat(softpdftype,nl,limi,probdens):

    L1 = limi[:,:-1]
    L2 = limi[:,1:]
    
    P1 = probdens[:,:-1]
    P2 = probdens[:,1:]

    fsp = (P2 - P1) / (L2 - L1)
    fso = P1 - L1 * fsp

    L1p2 = L1 * L1
    L1p3 = L1p2 * L1
    L1p4 = L1p3 * L1

    L2p2 = L2 * L2
    L2p3 = L2p2 * L2
    L2p4 = L2p3 * L2
    
    XsMean_mat = ( 1 / 2. ) * ( fso * (L2p2 - L1p2 ) ) + ( 1 / 3. ) * (fsp * ( L2p3 - L1p3) )
    Xs2Mean_mat = ( 1 / 3. ) * ( fso * ( L2p3 - L1p3 ) ) + ( 1 / 4. ) * ( fsp * ( L2p4 - L1p4 ) )


    XsMean = []
    Xs2Mean = []
    for nl_i, XsMean_i, Xs2Mean_i in zip( nl, XsMean_mat, Xs2Mean_mat ):
        
        XsMean.append( [ XsMean_i[ : nl_i[0] - 1].sum()] )
        Xs2Mean.append( [ Xs2Mean_i[ : nl_i[0] - 1].sum()] )

    XsMean, Xs2Mean = np.array( XsMean ), np.array( Xs2Mean )
    softmean = XsMean
    softvar = Xs2Mean - XsMean**2

    
        
    return softmean, softvar

def proba2probdens( softpdftype, nl, limi, probdens ):
    softpdftype = 2 # always 2
    norm_probdens = [ ]
    for nl_i, limi_i, probdens_i in zip( nl, limi, probdens):
        nl_i = int( nl_i[ 0 ] )
        limi_i = limi_i[ : nl_i ]
        probdens_i_original = probdens_i[:] #copy
        probdens_i = probdens_i[ :nl_i ]

        height = limi_i[ 1: ] - limi_i[ :-1 ]
        sum_up_low = probdens_i[ :-1 ] + probdens_i[ 1: ]
        area = (sum_up_low * height / 2.).sum()
        norm_probdens_i = probdens_i / area
        probdens_i_original[ :nl_i] = norm_probdens_i
        norm_probdens.append( probdens_i_original )

    return nl, limi, np.array( norm_probdens )

def proba2quantile( softdpftype, nl, limi, probdens, quantiles = [] ):
    '''give a discrete pdf, return the quantiles user gave'''

    #default quantiles
    if quantiles:
        pass
    else:
        quantiles = [ .05, .25, .50, .75, .95, ]

    
    #get cdf
    probdens_quantile = []
    # probdens_cdf = []

    for nl_i, limi_i, probdens_i in zip( nl, limi, probdens ):

        #clip
        nl_i = int( nl_i[ 0 ] )
        limi_i = limi_i[ : nl_i ]
        probdens_i = probdens_i[ :nl_i ]

        #get area_i
        height = limi_i[ 1: ] - limi_i[ :-1 ]
        sum_up_low = probdens_i[ :-1 ] + probdens_i[ 1: ]
        area_i = (sum_up_low * height / 2.)
        
        #set cdf
        probdens_cdf_i = [ 0. ]
        for p in area_i:
            probdens_cdf_i.append( probdens_cdf_i[ -1 ] + p )

        #get interp
        probdens_quantile.append( np.interp( quantiles, probdens_cdf_i, limi_i ) )

    return np.array( probdens_quantile )


if __name__ == "__main__":
    import numpy as np

    # mean = np.array([[0.],[0],[3],[7],[9]])
    # var = np.array([[1.],[3],[3],[4],[5]])

    # nl,limi,probdens = gs2ud(mean,var)
    
    # print nl
    # print limi
    # print probdens

    # res = proba2stat( 'dummy', nl, limi, probdens )
    # print res

    
    low = np.array([[1],[1],[2],[2],[3.]])
    up = np.array([[3],[4],[3],[4],[5.]])
   
    nl,limi,probdens = uf2ud(low,up)
    print nl
    print limi
    print probdens
   
    #res = proba2stat( 'dummy', nl, limi, probdens )
    res = proba2probdens( 'dummy', nl, limi, probdens )
    print res[0]
    print res[1]
    print res[2]

    import numpy
    cs = numpy.array([],ndmin=2)
    softpdftype = 1 #no use
    nlseq = numpy.array([],ndmin=2)
    limiseq = numpy.array([],ndmin=2)
    probadensseq = numpy.array([],ndmin=2)
    zs = ud2zs_temp(softpdftype, nlseq, limiseq, probadensseq)
    print zs
