# -*- coding: utf-8 -*-
import numpy
import os
import sys
import imp
import platform
import starpy


'''Here we should provide some platform check'''
PF=platform.platform()
if PF.startswith('Darwin'):
  os_platform = 'Mac' #unkown, use mac   
elif PF.startswith('Windows'):
  os_platform = 'Windows'
elif PF.startswith('Linux'):
  os_platform = 'Linux'    
else: 
  os_platform = 'Mac' # unknown is set as Mac
         
py_v = str( sys.version_info[ 0 ] )+str( sys.version_info[ 1 ] )
np_v = numpy.__version__[0]+numpy.__version__[2]

def loadDynamicModule( name, dirs ):
    try:
        sys.modules[ name ]
        return sys.modules[ name ]
    except KeyError:
        dir_name = os.path.join( starpy.__path__[0],
                                 'general',
                                 name,
                                 os_platform,
                                 *dirs )
        if not os.path.exists(dir_name):
            raise ImportError( "Sorry, We don't have %s module for %s" % ( name, 'and'.join(dirs) ) )                  
    
        try:
            f,f_name,desc = imp.find_module( name, [ dir_name ] )
        except ImportError as e: #name is given by us, shouldn't go here~
            raise ImportError( 'Strange Error:%s' % e.message)
        if f:
            sys.path.append(dir_name)
            try:
                dynamic_lib = imp.load_module( name, f, f_name, desc)
                return dynamic_lib
            finally:
                f.close()
        else:
            raise ImportError('Can not find %s for %s' % ( name, 'and'.join(dirs) ) )  

try:
    import nlopt #Ubuntu will success, Windows must be also successful because they already be installed.
except ImportError:
    if os_platform == 'Windows' or os_platform == 'Linux':
      print '''Warning: Module "nlopt" can't be found in your system, please install it first if you want to use.'''
    else:
      nlopt = loadDynamicModule( 'nlopt', [ 'Python{ver}'.format( ver = py_v ) ] )


def bobyqa(obj_func, init_guess, args, low_bnd, up_bnd,
    stop_val=None, maxeval=3000,
    ftol_rel=None, ftol_abs=None,
    xtol_rel=None, xtol_abs=None):
    '''
    Optimization by bobyqa method
    
    Function:
        bobyqa(obj_func, init_guess, args, low_bnd, up_bnd, maxeval)
    
    Input: 
    obj_func      function
        objective function to be minimized
    init_guess    array
        a 1D numpy array for the parameters to be estimated
    args          array
        a 1D numpy array for the function's arguments
    low_bnd       array
        optional. a 1D numpy array for parameter's lower bound
    up_bnd        array
        optional. a 1D numpy array for parameter's upper bound
    maxeval       int
        optional. a integer for maximum evaluation
    '''

    opt = nlopt.opt(nlopt.LN_BOBYQA, len(init_guess))
    opt.set_min_objective(
        lambda x, grad = numpy.array([]): obj_func(x, *args)
        )
    if not (low_bnd is None):
        opt.set_lower_bounds(low_bnd)
    if not (up_bnd is None):  
        opt.set_upper_bounds(up_bnd)
    if stop_val:
        opt.set_stopval(stop_val)
    opt.set_maxeval(maxeval)
    if ftol_rel:
        opt.set_ftol_rel(ftol_rel)
    if ftol_abs:
        opt.set_ftol_abs(ftol_abs)
    if xtol_rel:
        opt.set_xtol_rel(xtol_rel)
    if xtol_abs:
        opt.set_xtol_abs(xtol_abs)
    try:
        result = opt.optimize(init_guess)
    except nlopt.RoundoffLimited:
        print 'starpy Warning: roundoff limited found. Set relative value to 10**-8'
        opt.set_ftol_rel(10**-8)
        result = opt.optimize(init_guess)
    opt_val = opt.last_optimum_value()
    return result, opt_val
