# -*- coding: utf-8 -*-
import numpy


def isspacetime( model ):
  # add this for this function can adapt to the two current covmodel forms
  model=numpy.asarray(model)
  if (type(model[0]) is list) or (type(model[0]) is numpy.ndarray) \
      or (type(model[0]) is tuple):
    model0=model[0,0]
  elif (type(model[0]) is str) or (type(model[0]) is numpy.string_):
    model0=model[0]
      
  if '/' in model0:
    isST = True
    isSTsep = True
  else:
    isSTsep = False
    if 'ST' in model0:
      isST = True
    else:
      isST = False

  modelS = []
  modelT = []
  if isST:
    if isSTsep:
      for model_i in model:
        if (type(model_i) is list) or (type(model_i) is numpy.ndarray): 
          m_s, m_t = model_i[0].split('/')
        elif (type(model[0]) is str) or (type(model[0]) is numpy.string_):
          m_s, m_t = model_i.split('/')
        modelS.append( m_s )
        modelT.append( m_t )
    else:
      modelS = model
      modelT = model
  else:
    for model_i in model:
      m_s = model_i
      modelS.append( m_s )
      modelT.append( None ) # 0 NO_MODEL

  return isST, isSTsep, modelS, modelT


if __name__ == "__main__":
    models = numpy.array([("exponential/exponential"),("gaussian/gaussian")])
    res = isspacetime( models )
    for i in res:
        print i

    models = numpy.array([["nugget"],["exponential"]])
    res = isspacetime( models )
    for i in res:
        print i
        
    models = numpy.array(["exponential/exponential","gaussian/gaussian"])
    res = isspacetime( models )
    for i in res:
        print i

    models = numpy.array(["nugget","exponential"])
    res = isspacetime( models )
    for i in res:
        print i    
        
    models = [("exponential/exponential"),("gaussian/gaussian")]
    res = isspacetime( models )
    for i in res:
        print i

    models = [["nugget"],["exponential"]]
    res = isspacetime( models )
    for i in res:
        print i     
        
    models = ["exponential/exponential","gaussian/gaussian"]
    res = isspacetime( models )
    for i in res:
        print i

    models = ["nugget","exponential"]
    res = isspacetime( models )
    for i in res:
        print i            