'''
Created on 2013/12/29
I want to change all variable that use in all module to here
for maintain code speed
@author: KSJ
'''
import os
import sys
import numpy
import imp
import platform
import importlib
WORKING_FOLDER = r'.stbme'

PF = platform.platform()

if PF.startswith( 'Windows' ): #windows system

    from bsddb.db import DBPermissionsError as DBPERMISSIONSERROR
    WORKING_PATH = os.path.join( os.environ['USERPROFILE'], WORKING_FOLDER )
    SYS_ENCODING = "mbcs"
    DEFAULT_ENCODING = "utf8"
    GDALWARP = 'gdalwarp'

    if PF.startswith( 'Windows-XP' ): #xp
        SHELVE_ENCODING = 'cp950'
    else: #win7, win8, win-others
        SHELVE_ENCODING = 'utf8'
    
    os_platform = 'Windows'

elif PF.startswith( 'Darwin' ): #Mac
    SHELVE_ENCODING = 'utf8'
    WORKING_PATH = os.path.join( os.environ['HOME'], WORKING_FOLDER )
    from dbm import error as DBPERMISSIONSERROR
    SYS_ENCODING = "utf8"
    DEFAULT_ENCODING = "utf8"
    GDALWARP = '/Library/Frameworks/GDAL.framework/Programs/gdalwarp'
    
    os_platform = 'Mac'
elif PF.startswith( 'Linux' ): #Ubuntu
    SHELVE_ENCODING = 'utf8'
    WORKING_PATH = os.path.join( os.environ['HOME'], WORKING_FOLDER )
    from dbm import error as DBPERMISSIONSERROR
    SYS_ENCODING = "utf8"
    DEFAULT_ENCODING = "utf8"
    GDALWARP = '/usr/bin/gdalwarp'

    os_platform = 'Linux'
else:
    SHELVE_ENCODING = 'utf8'
    WORKING_PATH = os.path.join( os.environ['HOME'], WORKING_FOLDER)
    from dbm import error as DBPERMISSIONSERROR
    SYS_ENCODING = "utf8"
    DEFAULT_ENCODING = "utf8"
    GDALWARP = '/Library/Frameworks/GDAL.framework/Programs/gdalwarp'
    
    os_platform = 'Mac' #unkown, use mac
    

def loadDynamicModule( name, dirs ):
    try:
        sys.modules[ name ]
        return sys.modules[ name ]
    except KeyError:
        dir_name = os.path.join( os.path.abspath( os.path.dirname( __file__ ) ),
                                 'lib',
                                 name,
                                 os_platform,
                                 *dirs )
        if not os.path.exists(dir_name):
            raise ImportError( "Sorry, We don't have %s module for %s" % ( name, 'and'.join(dirs) ) )                  
    
        try:
            f,f_name,desc = imp.find_module( name, [ dir_name ] )
        except ImportError as e: #name is given by us, shouldn't go here~
            raise ImportError( 'Strange Error:%s' % e.message)
        if f:
            sys.path.append(dir_name)
            try:
                dynamic_lib = imp.load_module( name, f, f_name, desc)
                return dynamic_lib
            finally:
                f.close()
        else:
            raise ImportError('Can not find %s for %s' % ( name, 'and'.join(dirs) ) )  
        
           
py_v = str( sys.version_info[ 0 ] )+str( sys.version_info[ 1 ] )
np_v = numpy.__version__[0]+numpy.__version__[2]


def isModuleExists(module_syntax):
    try:
        importlib.import_module(module_syntax)
        return True
    except ImportError:
        return False

HAS_MODULE_NLOPT = isModuleExists('nlopt')
HAS_MODULE_PANDAS = isModuleExists('pandas')