# -*- coding: utf-8 -*-
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
import sys
import os


####copy ftools####
# Set up current path, so that we know where to look for modules
currentPath = os.path.dirname(__file__)
sys.path.append(os.path.abspath(os.path.dirname(__file__)))

# initialize Qt resources from file resouces.py
import resources
import star_variable
class BMEPlugin:
  def __init__(self, iface):
    # save reference to the QGIS interface
    self.iface = iface
  def initGui(self):
    # create action that will start plugin configuration
    self.action = QAction(
        QIcon(":/stemlab.png"), "STAR-BME", self.iface.mainWindow())
    #self.action.setWhatsThis("Configuration for test plugin BMEBMEBME")
    self.action.setStatusTip(
        "Modern spatiotemporal modelling and mapping"
        )
    self.action.triggered.connect(self.run)
    # add toolbar button and menu item
    self.iface.addToolBarIcon(self.action)
    self.iface.addPluginToMenu("&STAR", self.action)

  def unload(self):
    # remove the plugin menu item and icon
    self.iface.removePluginMenu("&STAR", self.action)
    self.iface.removeToolBarIcon(self.action)

  def run(self):
    #clean workspace

    if hasattr(self,"maindlg"):
        if self.maindlg.isHidden():
            self.maindlg.show()
        self.maindlg.raise_()
    else:
        #try to create temp folder
        if os.path.isdir(star_variable.WORKING_PATH):
            pass
        else:
            os.mkdir(star_variable.WORKING_PATH)
        try:
            root, dir_, file_ = os.walk(star_variable.WORKING_PATH).next()
            for d in dir_:
                shutil.rmtree(os.path.join(root, d))
            for f in file_:
                os.remove(os.path.join(root, f))
        except Exception:
            QMessageBox.critical(
                None, "Clean Workspace Error",
                "Some file still in used, please close other STAR-BME first.")
            return
        if not star_variable.isModuleExists('pandas'):
            msg_str = [
                "Cannot import module 'pandas', ",
                "STARBME cannot be used.\n",
                "Please install pandas first to use STARBME."]
            QMessageBox.critical(
                self.iface.mainWindow(), "Import error",
                "".join(msg_str)
                )
            return

        if not star_variable.isModuleExists('scipy'):
            msg_str = [
                "Cannot import module 'scipy', ",
                "STARBME cannot be used.\n",
                "Please install scipy first to use STARBME."]
            QMessageBox.critical(
                self.iface.mainWindow(), "Import error",
                "".join(msg_str)
                )
            return
        import scipy
        scipy_ver = scipy.__version__
        if int(scipy_ver.split('.')[1]) < 18 and\
            int(scipy_ver.split('.')[0]) < 1:
            # we need scipy 0.18 above
            msg_str = [
                "The scipy module version is low ({v}), ".format(
                    v=scipy_ver
                    ),
                "STARBME cannot be used.\n",
                "Please install scipy >= 0.18 first to use STARBME."]
            QMessageBox.critical(
                self.iface.mainWindow(), "Scipy version is not enough",
                "".join(msg_str)
                )
            return
        from gui import main
        self.maindlg =\
            main.MainWindow(self.iface, self.iface.mainWindow())
        self.maindlg.show()
        
    
    
